Scriptname _SLSubmitSmackEffect extends ActiveMagicEffect  

_SLSubmitConfig Property _SLConfig auto
_SLSubmitFunctions Property _SLFunctions auto
_SLSubmitQuest Property _SLQuest auto
_SLSubmitScene Property _SLScene auto
PlayerVampireQuestScript Property PVQ Auto
Keyword Property ActorTypeNPC  Auto  
import utility
import game

GlobalVariable Property AttemptCost  Auto  
GlobalVariable Property SuccessChance  Auto  
GlobalVariable Property SuccessRoll  Auto  
Float Property FailurePenalty  Auto 
GlobalVariable Property _SLSubmitFailurePenalty  Auto  
Idle Property _SLSubmitSmack  Auto  
float Property THealth  Auto
Topic Property _SLSubmitBleedOut Auto
Weapon Property TargetWeapon1  Auto  
Weapon Property TargetWeapon2  Auto  
Spell Property _SLSubmitUnarmed Auto
Spell Property _SLSubmitCalm Auto
MagicEffect Property CalmEffect Auto
Keyword Property Vampire Auto
ReferenceAlias Property ActorVictim  Auto  
Faction Property _SLSubmitFaction Auto
Faction Property _SLSubmitRecoverFaction Auto
Faction Property _SLSubmitBountyFaction Auto
Spell Property Slap Auto
Actor Property PlayerRef Auto

Event OnEffectStart(actor Target, actor Caster)
	If (Target.HasKeyword(ActorTypeNPC) && (Target.IsInCombat() || Target.HasMagicEffect(CalmEffect)))
; // Code for the success algorithm
		Target.GetLeveledActorBase().SetProtected()
		PlayerRef.DamageAV("Stamina",AttemptCost.GetValue())
		THealth = Target.GetAV("Health")/Target.GetBaseAV("Health")*100
		_SLQuest.GatherStats(Target,Caster)
		_SLQuest.ShoutChance()
		Slap.Cast(Caster)
		TargetWeapon1 = Target.getEquippedWeapon()
		TargetWeapon2 = Target.getEquippedWeapon(True)
		Game.DisablePlayerControls()
		_SLFunctions.UnArm(Caster)
		_SLScene.WRT(0.2)
		If !Caster.IsWeaponDrawn()		
			Caster.DrawWeapon()	
			_SLScene.WRT(0.5)
		EndIf
		Target.MoveTo(Caster, 15.0 * Math.Sin(Caster.GetAngleZ()), 15.0 * Math.Cos(Caster.GetAngleZ()))
		float zOffset = Target.GetHeadingAngle(Caster)
		Target.SetAngle(Target.GetAngleX(), Target.GetAngleY(), Target.GetAngleZ() + zOffset)
		Debug.SendAnimationEvent(Caster, "AttackStartH2HLeft")
		_SLScene.WRT(0.3)
; // Code for what happens on success
		If (THealth <= 90.0)
			If (SuccessChance.GetValue() >= SuccessRoll.GetValue())
				If (!Target.IsInFaction(_SLSubmitRecoverFaction))
					Target.AddToFaction(_SLSubmitRecoverFaction)
				EndIf
				If (_SLSubmitFailurePenalty.GetValue() > 0.0)
					FailurePenalty = _SLSubmitFailurePenalty.GetValue() - 10
					_SLSubmitFailurePenalty.SetValue(FailurePenalty)
				EndIf
				If(_SLConfig.debugActive)
					Debug.Notification(SuccessChance.GetValue() + "% success chance, " + SuccessRoll.GetValue() + "% rolled.  Target submits!")
				EndIf
				ActorVictim.ForceRefTo(Target)
				If (!Target.IsInFaction(_SLSubmitFaction))
					Target.AddToFaction(_SLSubmitFaction)
				EndIf
				_SLSubmitCalm.Cast(Target)
				Debug.SendAnimationEvent(Target, "IdleForceDefaultState")
				_SLScene.WRT(0.1)
				Target.StopCombat()
				If (Caster.HasKeyword(Vampire) && _SLConfig.VampireActive)
					Caster.StartVampireFeed(Target)
					_SLFunctions.SubmitFeed()
					Target.StopCombat()
				Else
					Caster.PlayIdleWithTarget(_SLSubmitSmack, Target)
					_SLScene.WRT(2.2)
				EndIf
				Debug.SendAnimationEvent(Target, "IdleForceDefaultState")
				If (_SLConfig.DisarmActive)
					If (TargetWeapon1 != none)
						Target.RemoveItem(TargetWeapon1, 1, false, Caster)
						Debug.Notification("You have disarmed " + Target.GetLeveledActorBase().GetName() + " and taken their " + TargetWeapon1.GetName() + "!")
					EndIf
					If (TargetWeapon2 != none)
						Target.RemoveItem(TargetWeapon2, 1, false, Caster)
						Debug.Notification("You have disarmed " + Target.GetLeveledActorBase().GetName() + " and taken their " + TargetWeapon2.GetName() + "!")
					EndIf
				EndIf
				_SLScene.WRT(0.5)
				Debug.SendAnimationEvent(Target, "BleedOutStart")
				_SLScene.WRT(0.1)
				Game.EnablePlayerControls()
				Target.Say(_SLSubmitBleedOut)
				_SLSubmitCalm.Cast(Target)
				Target.StopCombat()
				If (Caster.IsWeaponDrawn()	)
					Caster.SheatheWeapon()	
					_SLScene.WRT(0.1)
				EndIf
				_SLFunctions.ReArm(Caster)
				If !Caster.IsWeaponDrawn()		
					Caster.DrawWeapon()	
				EndIf
				_SLScene.WRT(0.5)
				If (Caster.HasKeyword(Vampire) && _SLConfig.VampireActive)
					PVQ.VampireProgression(PlayerRef, 1)
				EndIf
				If(PlayerRef.IsTrespassing())
					Target.SetRelationshipRank(PlayerRef,1)
				EndIf
				_SLScene.WRT(4.5)
				Caster.PushActorAway(Target, 0)
				_SLScene.WRT(5.0)
				If (Target.IsInFaction(_SLSubmitRecoverFaction))
					Target.RemoveFromFaction(_SLSubmitRecoverFaction)
				EndIf
				If (!Target.IsInFaction(_SLSubmitBountyFaction) && _SLQuest.IsHostileNPC(Target))
					Target.AddToFaction(_SLSubmitBountyFaction)
				EndIf
			Else
; // Code for what happens on failure
				If (_SLSubmitFailurePenalty.GetValue() < 50.0)
					FailurePenalty = _SLSubmitFailurePenalty.GetValue() + 10
					_SLSubmitFailurePenalty.SetValue(FailurePenalty)
				EndIf
				If(_SLConfig.debugActive)
					Debug.Notification(SuccessChance.GetValue() + "% success chance, " + SuccessRoll.GetValue() + "% rolled.  Target resists!")
				EndIf
				_SLScene.WRT(0.1)
				Game.EnablePlayerControls()
				float zOffset1 = Target.GetHeadingAngle(PlayerRef)
				Target.SetAngle(Target.GetAngleX(), Target.GetAngleY(), Target.GetAngleZ() + zOffset1)
				_SLScene.WRT(0.1)
				Debug.SendAnimationEvent(Target, "JumpLand")
				Debug.SendAnimationEvent(Caster, "StaggerStart")
				_SLScene.WRT(0.1)
				Target.startCombat(Caster)
				If Caster.IsWeaponDrawn()		
					Caster.SheatheWeapon()	
					_SLScene.WRT(0.1)
				EndIf
				_SLFunctions.ReArm(Caster)
				If !Caster.IsWeaponDrawn()		
					Caster.DrawWeapon()	
				EndIf
			EndIf
		Else
			If (_SLSubmitFailurePenalty.GetValue() < 50.0)
				FailurePenalty = _SLSubmitFailurePenalty.GetValue() + 10
				_SLSubmitFailurePenalty.SetValue(FailurePenalty)
			EndIf
			If(_SLConfig.debugActive)
				Debug.Notification("Target's health is " + THealth + "% and is over 90%.  Target automatically resists!")
			EndIf
			_SLScene.WRT(0.1)
			Game.EnablePlayerControls()
			float zOffset1 = Target.GetHeadingAngle(PlayerRef)
			Target.SetAngle(Target.GetAngleX(), Target.GetAngleY(), Target.GetAngleZ() + zOffset1)
			_SLScene.WRT(0.1)
			Debug.SendAnimationEvent(Target, "JumpLand")
			Debug.SendAnimationEvent(Caster, "StaggerStart")
			_SLScene.WRT(0.1)
			Target.startCombat(Caster)
			If Caster.IsWeaponDrawn()		
				Caster.SheatheWeapon()	
				_SLScene.WRT(0.1)
			EndIf
			_SLFunctions.ReArm(Caster)
			If !Caster.IsWeaponDrawn()		
				Caster.DrawWeapon()	
			EndIf
		EndIf
	Else
		If (_SLSubmitFailurePenalty.GetValue() < 50.0)
			FailurePenalty = _SLSubmitFailurePenalty.GetValue() + 10
			_SLSubmitFailurePenalty.SetValue(FailurePenalty)
		EndIf
		If(_SLConfig.debugActive)
			Debug.Notification("Target is an invalid target.  Target automatically resists!")
		EndIf
		_SLScene.WRT(0.1)
		Game.EnablePlayerControls()
		float zOffset1 = Target.GetHeadingAngle(PlayerRef)
		Target.SetAngle(Target.GetAngleX(), Target.GetAngleY(), Target.GetAngleZ() + zOffset1)
		_SLScene.WRT(0.1)
		Debug.SendAnimationEvent(Target, "JumpLand")
		Debug.SendAnimationEvent(Caster, "StaggerStart")
		_SLScene.WRT(0.1)
		Target.startCombat(Caster)
		If Caster.IsWeaponDrawn()		
			Caster.SheatheWeapon()	
			_SLScene.WRT(0.1)
		EndIf
		_SLFunctions.ReArm(Caster)
		If !Caster.IsWeaponDrawn()		
			Caster.DrawWeapon()	
		EndIf
	EndIf
EndEvent